/* 
 * parent.c 
 *
 */

#include "myheader.h"

enum { MSGSIZE = 20 };          /* Розмір повідомлення */


extern int parent(pid_t child_pid)
{
        int child_status;
        char message[MSGSIZE];

        assert(child_pid > 0);
        assert(stream != NULL);

        printf("Parent: My PID is %u and my child's PID is %u\n",
                                        (unsigned int) getpid(),
                                        (unsigned int) child_pid);
        /* Чекає на завершення дочірнього процесу. */
        wait(&child_status);
        /* Виводить код завершення дочірнього процесу. */
        printf("Parent: Child exited with code %d\n", child_status);
        /* Намагається отримати повідомлення від дочірнього процесу. */
        if (fseek(stream, 0, SEEK_SET) != 0) {
                fprintf(stderr, "Parent: Error seeking in temporary file:"
                                                " %s\n", strerror(errno));
                return 1;
        }
        if (fgets(message, MSGSIZE, stream) == NULL) {
                if (ferror(stream)) {
                        fprintf(stderr, "Parent: Error reading from"
                                " temporary file: %s\n", strerror(errno));
                        return 1;
                }
                printf("Parent: No message from child"
                                        " has been received\n");
                return 0;
        }
        /* Виводить повідомлення, отримане від дочірнього процесу. */
        printf("Parent: A message from child has been received:\n"
                                                        "%s\n", message);
        return 0;	
}
